
#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <io.h>

#pragma hdrstop

#define NEWBASE 0xCCC00000            // change imagebase (used if defined)

#define align(x,y)      (((x)+(y)-1)&(~((y)-1)))
#define MIN(x,y)        ((x)<(y)?(x):(y))
#define MAX(x,y)        ((x)>(y)?(x):(y))

#define MAX_FIXUP_SIZE  131072          // max new fixup table size

#include "mz.hpp"
#include "pe.hpp"

void main(int argc, char* argv[])
{
  printf("FIXUP REVERSER  (x) 2000   right toolz for the right job\n");

  if ((argc != 2) && (argc != 3))
  {
    printf("\nsyntax: FIXUP [infile.EXE [outfile.EXE]]\n");
    exit(0);
  }

  char *ifile, *ofile;

  if (argc==2)
  {
    ifile = argv[1];
    ofile = (char*)malloc(strlen(ifile)+16);
    strcpy(ofile, ifile);
    char* c = strrchr(ofile,'.');
    if (c) *c = 0;
    strcat(ofile, "!.exe");
  }

  if (argc==3)
  {
    ifile = argv[1];
    ofile = argv[2];
  }

  printf(" reading %s\n", ifile);

  FILE*f=fopen(ifile,"rb");
  assert(f);
  DWORD bufsize = filelength(fileno(f));
  BYTE* buf = new BYTE[bufsize];
  fread(buf, 1,bufsize, f);
  fclose(f);

  printf(" analyzing\n");

  MZ_HEADER* mz = (MZ_HEADER*)&buf[0];
  PE_HEADER* pe = (PE_HEADER*)&buf[mz->mz_neptr];
  PE_OBJENTRY* oe = (PE_OBJENTRY*)&buf[mz->mz_neptr + 0x18 + pe->pe_ntheadersize];

  if ((pe->pe_flags & 1) == 0)
  {
    printf("***ERROR***: fixups alredy present\n");
    exit(0);
  }

  DWORD ovr_offs = oe[pe->pe_numofobjects-1].oe_physoffs +
               align(oe[pe->pe_numofobjects-1].oe_physsize, pe->pe_filealign);
  DWORD ovr_size = bufsize - ovr_offs;

  DWORD t1 = 0;
  for (DWORD i = 0; i < ovr_size; i++)
    t1 |= buf[i];
  if (t1 == 0) ovr_size = 0;

  BYTE* x = new BYTE[MAX_FIXUP_SIZE];
  memset(x, 0, MAX_FIXUP_SIZE);
  DWORD xptr = 0, o = 0, xbase;

//DWORD numsect = MIN(2,pe->pe_numofobjects);
  DWORD numsect = pe->pe_numofobjects - 1;
  printf("- processing %i section(s)\n", numsect);

  for (DWORD n=0; n<numsect; n++)
  for (DWORD p=oe[n].oe_physoffs, v=oe[n].oe_virtrva;
       p < oe[n].oe_physoffs+oe[n].oe_physsize;
       p++, v++)
  {
    DWORD t = *(DWORD*)&buf[p] - pe->pe_imagebase;
    if (t >= pe->pe_baseofcode)
    if (t <  pe->pe_imagesize)
    {

#ifdef NEWBASE
      *(DWORD*)&buf[p] = t + NEWBASE;
#endif

      if (o == 0)
      {
c1:     xbase = v & 0xFFFFF000;
        *(DWORD*)&x[xptr+0] = xbase;
        o = 8;
      }

      if (v - xbase > 0xFFF)
      {
        *(DWORD*)&x[xptr+4] = o;
        xptr += o;
        goto c1;
      }

      if (xptr+o+2 >= MAX_FIXUP_SIZE)
      {
        printf("***ERROR***: too many fixups\n");
        exit(0);
      }

      *(WORD*)&x[xptr+o] = (v - xbase) | 0x3000;
      o += 2;

    } // t
  } // for p,v

#ifdef NEWBASE
  pe->pe_imagebase = NEWBASE;
#endif

  if (o != 0)
  {
    *(DWORD*)&x[xptr+4] = o;
    xptr += o;
  }

  if (xptr == 0)
  {
    printf("***ERROR***: too many fixups\n");
    exit(0);
  }

  memcpy(oe[pe->pe_numofobjects].oe_name, ".reloc\x00\x00", 8);
  oe[pe->pe_numofobjects].oe_physoffs = oe[pe->pe_numofobjects-1].oe_physoffs + align(oe[pe->pe_numofobjects-1].oe_physsize, pe->pe_filealign);
  oe[pe->pe_numofobjects].oe_virtrva  = oe[pe->pe_numofobjects-1].oe_virtrva  + align(oe[pe->pe_numofobjects-1].oe_virtsize, pe->pe_objectalign);
  oe[pe->pe_numofobjects].oe_physsize = align(xptr, pe->pe_filealign);
  oe[pe->pe_numofobjects].oe_virtsize = align(xptr, pe->pe_objectalign);
  pe->pe_imagesize += oe[pe->pe_numofobjects].oe_virtsize;
  pe->pe_fixuprva = oe[pe->pe_numofobjects].oe_virtrva;
  pe->pe_fixupsize = xptr;
  pe->pe_numofobjects++;
  pe->pe_flags ^= 1;

  printf(" writing %s\n", ofile);

  f=fopen(ofile,"wb");
  assert(f);
  fwrite(buf, 1, oe[pe->pe_numofobjects-1].oe_physoffs, f);
  fwrite(x,   1, oe[pe->pe_numofobjects-1].oe_physsize, f);
  fwrite(&buf[ovr_offs], 1,ovr_size, f);
  fclose(f);
}
