<?php
/*
* Prevent certain member groups from viewing threads. 
* But still be able to view threadlist.
*
* Copyright 2012 Anori
*/

$plugins->add_hook('showthread_start', 'mgcvthreads_block');
$plugins->add_hook('archive_thread_start', 'mgcvthreads_block');
$plugins->add_hook('printthread_start', 'mgcvthreads_block');

function mgcvthreads_info()
{
    return array(
        "name"        => "Member groups cant view threads",
        "description"    => "Shows a no permission page to selected user groups.<br />When they try to view a thread.",
        "website"        => "http://community.mybb.com/user-59864.html",
        "author"        => "Anori",
        "authorsite"    => "http://community.mybb.com/user-59864.html",
        "version"        => "1.4.1",
        "guid"            => "4a1551bc46ad53fe28aae148d6cc7793",
        "compatibility" => "18*"
    );
}
function mgcvthreads_install()
{
    global $db;
    
    $insert_array = array(
        'title'        => 'mgcvthreads_no_permission',
        'template'    => $db->escape_string('{$lang->error_nopermission_guest_1}
<ol>
<li>{$lang->error_nopermission_guest_2}</li>
<li>{$lang->error_nopermission_guest_3}</li>
<li>{$lang->error_nopermission_guest_4}</li>
<li>{$lang->error_nopermission_guest_5}</li>
</ol>
<form action="member.php" method="post">
<input type="hidden" name="action" value="do_login" />
<input type="hidden" name="url" value="{$redirect_url}" />
<table border="0" cellspacing="{$theme[\'borderwidth\']}" cellpadding="{$theme[\'tablespace\']}" class="tborder">
<tr>
<td class="thead" colspan="2"><span class="smalltext"><strong>{$lang->login}</strong></span></td>
</tr>
<tr>
<td class="trow1"><strong>{$lang->username}</strong></td>
<td class="trow1"><input type="text" class="textbox" name="username" tabindex="1" /></td>
</tr>
<tr>
<td class="trow2"><strong>{$lang->password}</strong></td>
<td class="trow2"><input type="password" class="textbox" name="password" tabindex="2" /></td>
</tr>
<tr>
<td class="trow2" colspan="2"><span class="smalltext" style="float:right; padding-top:3px;"><a href="member.php?action=register">{$lang->need_reg}</a> | <a href="member.php?action=lostpw">{$lang->forgot_password}</a>&nbsp;</span>&nbsp;<input type="submit" class="button" value="{$lang->login}" tabindex="3" /></td>
</tr>
</table>
</form>
<br />'),
        'sid'        => '-1',
        'version'    => '',
        'dateline'    => TIME_NOW
    );
    $db->insert_query("templates", $insert_array);
    
    $insert_array2 = array(
        'title'        => 'mgcvthreads_no_permission_loggedin',
        'template'    => $db->escape_string('{$lang->error_nopermission_user_1}
<ol>
    <li>{$lang->error_nopermission_user_2}</li>
    <li>{$lang->error_nopermission_user_3}</li>
    <li>{$lang->error_nopermission_user_4} (<a href="member.php?action=resendactivation">{$lang->error_nopermission_user_resendactivation}</a>)</li>
    <li>{$lang->error_nopermission_user_5}</li>
</ol>
<br />
{$lang->error_nopermission_user_username}'),
        'sid'        => '-1',
        'version'    => '',
        'dateline'    => TIME_NOW
    );
    $db->insert_query("templates", $insert_array2); 
    
    $gid = $db->insert_query('settinggroups', array(
        'name' => 'mgcvthreads',
        'title' => 'Member groups cant view threads',
        'description' => "Settings for the Member groups cant view threads plugin",
        'disporder' => 1,
        'isdefault' => 0
    ));
        $db->insert_query('settings', array(
        'name' => 'mgcvthreads_enable',
        'title' => 'Enable or Disable Plugin',
        'description' => 'Enable or disable the plugin',
        'optionscode' => 'onoff',
        'value' => '1',
        'disporder' => 1,
        'gid' => $gid
    ));
    $db->insert_query('settings', array(
        'name' => 'mgcvthreads_groups',
        'title' => 'Select the user groups',
        'description' => 'Select which user groups are not allowed to view threads (use , to sepperate multiple user groups).',
        'optionscode' => 'text',
        'value' => '1',
        'disporder' => 2,
        'gid' => $gid
    ));
    $db->insert_query('settings', array(
        'name' => 'mgcvthreads_template',
        'title' => 'Use custom no permissions template',
        'description' => 'Do you wish to use custom no permission templates, or do you wish to use the MyBB default no_permission templates?',
        'optionscode' => 'radio
cust=Custom no_permission templates.
def=Default MyBB no_permission templates.',
        'value' => 'cust',
        'disporder' => 3,
        'gid' => $gid
    ));
    $db->insert_query('settings', array(
        'name' => 'mgcvthreads_forums',
        'title' => 'For which forums this plugin should run.',
        'description' => 'Select in which forums you wish to run this plugin.<br /> 
Leave empty to enable it in all the forums, or to run it in multiple forums use commas to sepperate them: <br /> 
Example: 1,2,3,4',
        'optionscode' => 'text',
        'value' => '',
        'disporder' => 4,
        'gid' => $gid
    ));
    rebuild_settings();
}

function mgcvthreads_is_installed()
{
    global $mybb, $db;
    
    $query = $db->simple_select("settinggroups", "name", "name = 'mgcvthreads'");
    $result = $db->fetch_array($query);
    if($result)
        return true;
    else return false;
}

function mgcvthreads_activate()
{
}
function mgcvthreads_deactivate()
{    
}
function mgcvthreads_uninstall()
{
    global $db;
    require_once MYBB_ROOT . "inc/adminfunctions_templates.php";
    
    $db->delete_query("templates", "title IN ('mgcvthreads_no_permission')");
    $db->delete_query("templates", "title IN ('mgcvthreads_no_permission_loggedin')");
    $db->delete_query("settinggroups", "name = ('mgcvthreads')");
    $db->delete_query("settings", "name IN ('mgcvthreads_enable')");
    $db->delete_query("settings", "name IN ('mgcvthreads_groups')");
    $db->delete_query("settings", "name IN ('mgcvthreads_template')");
    $db->delete_query("settings", "name IN ('mgcvthreads_forums')");
}
function mgcvthreads_block() 
{
    global $db, $mybb, $lang, $thread, $templates;

    if($mybb->settings['mgcvthreads_enable'] == "1")  
    {
        $mgcvtFid = '';
        if($mybb->settings['mgcvthreads_forums'] !== '')
        {
            $mgcvtFid = $thread['fid'];
            if(!$mgcvtFid || $mgcvtFid === '')
            {
                $mgcvtTid = $mybb->input['tid'];
                $mgcvtQuery = $db->simple_select("threads", "fid", "tid='".$mgcvtTid."'");
                if($db->num_rows($mgcvtQuery) == 0)
                {
                    error($lang->error_invalidthread);
                }
                $mgcvtThread = $db->fetch_array($mgcvtQuery);
                $mgcvtFid = $mgcvtThread['fid'];
            }
        }
        $mgcvtForums = explode(',',$mybb->settings['mgcvthreads_forums']);
        if((in_array($mgcvtFid, $mgcvtForums)) or ($mybb->settings['mgcvthreads_forums'] === ''))
        {

            $mgcvtGroups = explode(",", $mybb->settings['mgcvthreads_groups']);
            if(in_array($mybb->user['usergroup'], $mgcvtGroups))
            {
                $lang->load("messages");
                $lang->load("global");
                if($mybb->user['uid'])
                {
                    if($mybb->settings['mgcvthreads_template'] == "cust")
                    {
                        $lang->error_nopermission_user_username = $lang->sprintf($lang->error_nopermission_user_username, $mybb->user['username']);
                        eval("\$mgcvthreads_no_permission_loggedin = \"".$templates->get("mgcvthreads_no_permission_loggedin")."\";");
                        error($mgcvthreads_no_permission_loggedin);
                    }
                    else
                    {
                        error_no_permission();
                    }

                }
                else
                {
                    if($mybb->settings['mgcvthreads_template'] == "cust")
                    {
                        eval("\$mgcvthreads_no_permission = \"".$templates->get("mgcvthreads_no_permission")."\";");
                        error($mgcvthreads_no_permission);
                    }
                    else
                    {
                        error_no_permission();
                    }
                
                }
            }
        }
    }
}
?>