@echo off
:: Change directory to script location
pushd "%~dp0"

echo current directory: %CD% >>C:\SWWORK\Modules.log
SET CMDERR=0
SET jg_path_to_log_file=.\install-mep-optin.log

:: Verify admin
NET SESSION >nul 2>&1
IF %ERRORLEVEL% NEQ 0 (
   SET CMDERR=%errorlevel%
   GOTO install_mep_optin_error_admin
)

:: Check that RTP tag exists
echo Checking RTP tag...
IF EXIST C:\SWWORK\1701.tag (
   echo RTP Tag found: Skipping Lenovo MEP Opt-in Installation
   echo "RTP Tag found: Skipping Lenovo MEP Opt-in Installation" >> %jg_path_to_log_file%
   GOTO :install_mep_optin_end
)

:: Check that AMD IPU tag exists
echo Checking AMD IPU tag...
IF EXIST C:\Windows\NOIPU.tag (
   echo AMD IPU Tag found: Skipping Lenovo MEP Opt-in Installation
   echo "AMD IPU Tag found: Skipping Lenovo MEP Opt-in Installation" >> %jg_path_to_log_file%
   GOTO :install_mep_optin_end
)

:install_mep_optin
ECHO Install Lenovo MEP Opt-in >>C:\SWWORK\Modules.log
%SystemRoot%\System32\PnPutil.exe -i -a LnvMEPOptIn.inf >>C:\SWWORK\Modules.log

goto install_mep_optin_complete

:install_mep_optin_error_admin
echo Error: This script requires admin >>C:\SWWORK\Modules.log
echo "Error: This install requires admin" >> %jg_path_to_log_file%
GOTO install_mep_optin_end

:install_mep_optin_error_no_ipu
echo Error: This machine does not have AMD IPU driver. >>C:\SWWORK\Modules.log
echo "Error: This machine does not have AMD IPU driver." >> %jg_path_to_log_file%
GOTO install_mep_optin_end

:install_mep_optin_complete
SET CMDERR=0
echo Lenovo MEP Opt-in installation complete >>C:\SWWORK\Modules.log

:install_mep_optin_end
popd
exit /b %CMDERR%