
// AVP false-alarm-generator, http://z0mbie.cjb.net

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <assert.h>
#include <string.h>
#include <dir.h>
#include <io.h>
#pragma hdrstop

typedef unsigned long dword;
typedef unsigned char byte;
typedef unsigned short word;

#pragma pack(push)
#pragma pack(1)

typedef struct stamm_struct
{
  byte        cs1_size;    //               00
  word        cs1_offs;    //               01 02
  word        cs_word;     //               03 04
  byte        flags;       //               05
  dword       cs1_cs;      //               06 07 08 09
  byte        cs2_size;    //               0A
  word        cs2_offs;    //               0B 0C
  dword       cs2_cs;      //               0D 0E 0F 10
  word        objn;        //  or FFFF      11 12
  dword       nameo;       //               13 14 15 16
  byte        unk3[11];    //               17 .. 21
} stamm;

#pragma pack(pop)

dword calccsum(byte* data, dword size)
{
  dword c=0;
  for (dword i=0; i<size; i++)
  {
    if (i<4) c^=c<<8; else c^=c<<1;
    c^=data[i];
  }
  return c;
}

#define MAXBUFSIZE 32768
byte buf[MAXBUFSIZE];
byte bit[32][256*8];

int buildcsum(byte* buf, dword csize, dword needcsum)
{

  memset(bit,0,sizeof(bit));

  for (dword i=0; i<csize; i++)
  {
    dword q=i<4?8:1;
    for (dword j=31; j>=q; j--)
      for (dword k=0; k<csize*8; k++)
        bit[j][k]^=bit[j-q][k];
    for (dword j=0; j<8; j++)
      bit[j][i*8+j]^=1;
  }

  dword c=0;
  for (dword i=0; i<32; i++)
  {
    for (dword j=0; j<csize*8; j++)
      if (bit[i][j])
        c^=((buf[j>>3]>>(j&7))&1)<<i;
  }
  if (c!=calccsum(buf,csize)) return 0;

  for (dword i=0; i<32; i++)
    for (dword j=0; j<csize*8; j++)
      if (bit[i][j])
        bit[i][j]=255;

  for (;;)
  {
    int c=0;
    for (dword i=0; i<32; i++)
    {
      if (((calccsum(buf,csize)^needcsum)>>i)&1)
      {
        for (dword j=csize*8-1; j>=2*8; j--)
        if (bit[i][j])
        {
          bit[i][j]--;
          buf[j>>3]^=1<<(j&7);
          c++;
          goto ok;
        }
//      printf("***FAILED***");
        return 0;
  ok:
      }
    }
    if (!c) break;
  }

  return (calccsum(buf,csize)==needcsum);
}

int okfile=0;

void tryfile(char* fname)
{
  printf("trying file: %s -- ",fname);
  FILE*f = fopen(fname,"rb");
  if (f==NULL)
  {
    printf("not found\n");
    return;
  }

  stamm h;
  int c=0,l=0;

  if ((filelength(fileno(f))%0x22)!=0)
  {
    printf("[size is not %%0x22==0] -- aborted\n");
    fclose(f);
    return;
  }
  else
  {
    printf("OK, processing\n");
  }

  okfile++;

//fseek(f,0x21,SEEK_SET);

  while (!feof(f))
  {
    if (fread(&h, 1,sizeof(h), f)!=sizeof(h)) break;
    l++;

//  for (int i=0; i<26; i++)
//    printf("%02X ",*(byte*)((dword)&h+i));
//  printf("\n");

/*  printf("w=%04X %04X/%02X/%08X  %04X/%02X/%08X  fl=%02X on=%04X no=%08X\n",
      h.cs_word,
      h.cs1_offs,
      h.cs1_size,
      h.cs1_cs,
      h.cs2_offs,
      h.cs2_size,
      h.cs2_cs,
      h.flags,
      h.objn,
      h.nameo); */

    dword maxsize = max(h.cs1_offs+h.cs1_size,
                        h.cs2_offs+h.cs2_size);

    if (maxsize<MAXBUFSIZE-16)
    {
      memset(buf,0,maxsize);

      *(word*)&buf[h.cs1_offs]=h.cs_word;

      printf("(%i/%i) ",l,c);

      int i=0;
      if (h.cs1_size!=0)
      i+=2*buildcsum(&buf[h.cs1_offs], h.cs1_size, h.cs1_cs);
      if (h.cs2_size!=0)
      i+=buildcsum(&buf[h.cs2_offs], h.cs2_size, h.cs2_cs);

      printf("[%i]\x0D",i);

      if (i>=2)
      {

      char s[32]="samples\\test";
      itoa(c++,&s[strlen(s)],10);
      strcat(s,".com");

//    printf("writing %s\n",s);

      FILE*f=fopen(s,"wb");
      fwrite(&buf, 1,maxsize, f);
      fclose(f);

      }

    }

  }
  fclose(f);
}

void main(int argc, char* argv[])
{
  mkdir("samples");
  
  if (argc==2)
  {
    tryfile(argv[1]);
  }
  else
  {
    tryfile("_sta0001.sta");
    tryfile("_sta0002.sta");
    tryfile("_sta0003.sta");
    tryfile("_sta0004.sta");
  }

  if (okfile==0)
  {
    printf("syntax: AVPFUCK2 [_staXXXX.sta]\n");
  }
}//main()
