
; XDTPROT -- protect IDT/GDT/LDT pages

; programmed by Z0MBiE/29A -- March 24, 1999
; v 1.01     by Z0MBiE     -- August 6, 1999
; v 1.02                   -- October 4, 1999
;   - LDT protection fixed
;   - entering ring0 now via LDT

extrn                   IsBadWritePtr:PROC
extrn                   ExitProcess:PROC

include                 vxdcall.inc

                        p386
                        model   flat
                        locals  __
                        jumps

                        .data

                        db      ?

                        .code

start:

                        lea     esi, ring0proc
                        call    call_in_ring0

                        push    -1
                        call    ExitProcess

include                 callgate.inc

ring0proc:              pusha

IFDEF   _IDT_
                        push    eax
                        push    eax
                        sidt    [esp+2]
                        pop     ecx             ; limit<<16
                        pop     ebx             ; base
                        shr     ecx, 16
                        call    main
ENDIF

IFDEF   _GDT_
                        push    eax
                        push    eax
                        sgdt    [esp+2]
                        pop     ecx             ; limit<<16
                        pop     ebx             ; base
                        shr     ecx, 16
                        call    main
ENDIF

IFDEF   _LDT_
                        push    ecx
                        sgdt    [esp-2]
                        pop     ecx             ; base

                        xor     eax, eax
                        sldt    ax
                        and     eax, not (111b)

                        add     ecx, eax

                        mov     bh, [ecx+7]          ; LDT base
                        mov     bl, [ecx+4]
                        shl     ebx, 16
                        mov     bx, [ecx+2]

                        movzx   ecx, word ptr [ecx]  ; LDT limit

                        call    main
ENDIF

                        popa
                        retf


                        ; input: ebx=xdt.base
                        ;        ecx=xdt.limit<<16

main:
                        inc     ecx             ; 'coz limit=size-1

                        add     ecx, 4095       ; page count
                        shr     ecx, 12

;                       test    ebx, 4095       ; very strange situation
;                       jnz     $

                        shr     ebx, 12         ; page address - shr-ed by 12

                        push    0               ; OR_MASK
                        push    not (PC_WRITEABLE+PC_USER)      ; AND_MASK
                        push    ecx             ; count
                        push    ebx             ; offs>>12
                        VMMcall PageModifyPermissions
                        add     esp, 4*4

                        ret

                        end     start
