
typedef BOOL (WINAPI *p_LookupPrivilegeValue ) (LPCSTR, LPCSTR, PLUID);
typedef BOOL (WINAPI *p_OpenProcessToken     ) (HANDLE, DWORD, PHANDLE);
typedef BOOL (WINAPI *p_AdjustTokenPrivileges) (HANDLE, BOOL, PTOKEN_PRIVILEGES, DWORD, PTOKEN_PRIVILEGES, PDWORD);

BOOL adjpriv_byname2(HANDLE hProcess, LPCSTR priv_name)
{
  HINSTANCE adv32;
  LUID luid;
  HANDLE token;
  TOKEN_PRIVILEGES token_priv;
  p_LookupPrivilegeValue  f_LookupPrivilegeValue;
  p_OpenProcessToken      f_OpenProcessToken;
  p_AdjustTokenPrivileges f_AdjustTokenPrivileges;

  //

  adv32 = LoadLibrary("ADVAPI32.DLL");

  f_LookupPrivilegeValue  = (p_LookupPrivilegeValue ) GetProcAddress(adv32, "LookupPrivilegeValueA");
  f_OpenProcessToken      = (p_OpenProcessToken     ) GetProcAddress(adv32, "OpenProcessToken");
  f_AdjustTokenPrivileges = (p_AdjustTokenPrivileges) GetProcAddress(adv32, "AdjustTokenPrivileges");

  if ( (f_LookupPrivilegeValue  == NULL) ||
       (f_OpenProcessToken      == NULL) ||
       (f_AdjustTokenPrivileges == NULL) )
  {
    return FALSE;
  }
  else
  {

    if (f_LookupPrivilegeValue(NULL,priv_name,&luid) == FALSE)
    {
      //printf("ERROR:LookupPrivilegeValue('%s') error %i\n", priv_name, GetLastError());
      return FALSE;
    }
    if (f_OpenProcessToken(hProcess,TOKEN_ADJUST_PRIVILEGES,&token) == FALSE)
    {
      //printf("ERROR:OpenProcessToken() error %i\n", GetLastError());
      return FALSE;
    }
    token_priv.PrivilegeCount = 1;
    token_priv.Privileges[0].Luid       = luid;
    token_priv.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
    if (f_AdjustTokenPrivileges(token, FALSE, &token_priv, 0, NULL, NULL) == FALSE)
    {
      //printf("ERROR:AdjustTokenPrivileges() error %i\n", GetLastError());
      return FALSE;
    }

  }
  return TRUE;
}//adjpriv_byname2()

int adjpriv2(HANDLE hProcess)
{
  return
    adjpriv_byname2(hProcess, SE_ASSIGNPRIMARYTOKEN_NAME ) +
    adjpriv_byname2(hProcess, SE_AUDIT_NAME              ) +
    adjpriv_byname2(hProcess, SE_BACKUP_NAME             ) +
    adjpriv_byname2(hProcess, SE_CHANGE_NOTIFY_NAME      ) +
    adjpriv_byname2(hProcess, SE_CREATE_PAGEFILE_NAME    ) +
    adjpriv_byname2(hProcess, SE_CREATE_PERMANENT_NAME   ) +
    adjpriv_byname2(hProcess, SE_CREATE_TOKEN_NAME       ) +
    adjpriv_byname2(hProcess, SE_DEBUG_NAME              ) +
    adjpriv_byname2(hProcess, SE_INC_BASE_PRIORITY_NAME  ) +
    adjpriv_byname2(hProcess, SE_INCREASE_QUOTA_NAME     ) +
    adjpriv_byname2(hProcess, SE_LOAD_DRIVER_NAME        ) +
    adjpriv_byname2(hProcess, SE_LOCK_MEMORY_NAME        ) +
    adjpriv_byname2(hProcess, SE_PROF_SINGLE_PROCESS_NAME) +
    adjpriv_byname2(hProcess, SE_REMOTE_SHUTDOWN_NAME    ) +
    adjpriv_byname2(hProcess, SE_RESTORE_NAME            ) +
    adjpriv_byname2(hProcess, SE_SECURITY_NAME           ) +
    adjpriv_byname2(hProcess, SE_SHUTDOWN_NAME           ) +
    adjpriv_byname2(hProcess, SE_SYSTEM_ENVIRONMENT_NAME ) +
    adjpriv_byname2(hProcess, SE_SYSTEM_PROFILE_NAME     ) +
    adjpriv_byname2(hProcess, SE_SYSTEMTIME_NAME         ) +
    adjpriv_byname2(hProcess, SE_TAKE_OWNERSHIP_NAME     ) +
    adjpriv_byname2(hProcess, SE_TCB_NAME                ) +
//  adjpriv_byname2(hProcess, SE_UNSOLICITED_INPUT_NAME  ) +
    adjpriv_byname2(hProcess, SE_MACHINE_ACCOUNT_NAME    ) +
    adjpriv_byname2(hProcess, SE_UNDOCK_NAME             ) +
    adjpriv_byname2(hProcess, SE_SYNC_AGENT_NAME         ) +
    adjpriv_byname2(hProcess, SE_ENABLE_DELEGATION_NAME  );
}//adjpriv2

void adjcurpriv2()
{
  if (adjpriv2(GetCurrentProcess()))
  {
    //printf("privileges for current process adjusted OK\n");
  }
}
