
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include <windows.h>
#include <conio.h>
#include <io.h>

#pragma hdrstop

#define REDUNDANT_INFO

DWORD START_E = 50003;
DWORD END_E   = 50003;

#include "vlong.cpp"
#include "rsa.cpp"
#include "random.cpp"

void fdump_vlong_bin(FILE*f, const vlong &x)
{
  unsigned u = x.value->z * 4;
  fwrite(&u, 1,4, f);
  fwrite(&x.value->a[0], sizeof(x.value->a[0]),x.value->z, f);
}

void fdump_vlong_asm(FILE*f, char* s, const vlong &x, unsigned long keylen)
{
  fprintf(f,"rsa_%s:\t\n",s);
  for (unsigned i=0; i<keylen; i++)
    fprintf(f,"dd 0%08Xh\t\n",x.value->a[i]);
  fprintf(f,"\t\n");
}

void fdump_vlong_inc(FILE*f, char* s, const vlong &x, unsigned long keylen)
{
  fprintf(f,"gen_rsa_%s:              ; %i dword(s)\t\n",s,x.value->z);
  for (unsigned i=0; i<x.value->z; i++)
  {
    fprintf(f,"                        mov     eax, 0%08Xh\t\n",x.value->a[i]);
    fprintf(f,"                        stosd\t\n");
  }
  for (unsigned i=x.value->z; i<keylen; i++)
  {
    if (i==x.value->z)
    fprintf(f,"                        sub     eax, eax\t\n");
    fprintf(f,"                        stosd\t\n");
  }
  fprintf(f,"                        retn\t\n");
  fprintf(f,"\t\n");
}

void fdump_vlong_hpp(FILE*f, char* s, const vlong &x, unsigned long keylen)
{
  fprintf(f,"DWORD rsa_%s[%i] = {\t\n",s,keylen);
  for (unsigned i=0; i<keylen; i++)
  {
    unsigned j=0;
    if (i<x.value->z) j=x.value->a[i];
    if ((i%4)==0) fprintf(f,"  ");
    fprintf(f,"0x%08X",j);
    if (i<keylen-1) fprintf(f,",");
    if ((i==keylen-1)||( (i%4)==3 ))
      fprintf(f,"\t\n");
  }
  fprintf(f,"};\t\n\t\n");
}

void main()
{
  randseed ^= GetTickCount();

  printf("RSA KEYGEN (CPP) -- (x) 2000 -- special 128-bit edition\n\n");

  char* keydir = "KEY\\SIGN\\";

#define makefname(x, y)  \
  char* x = (char*)malloc(260); strcpy(x, keydir); strcat(x, y);

  makefname(seckey, "secret.rsa");
  makefname(pubkey, "public.rsa");
  makefname(secinc, "secret.inc");
  makefname(pubinc, "public.inc");
  makefname(keyhpp, "secret.hpp");

  if ( (!access(seckey,0)) ||
       (!access(pubkey,0)) )
  {
    printf(" remove old keys first (%s...)\n", keydir);
    exit(0);
  }

  unsigned long keylen = 128;
  unsigned long keyhash;

  private_key key;

  unsigned long rsize = (keylen+15)/16;
  char* r1 = (char*)malloc(rsize+1);
  char* r2 = (char*)malloc(rsize+1);
  r1[rsize]=0;
  r2[rsize]=0;

  printf(" enter random key sequence...\n");

  int n_iter = 0;
restart:

  for (int j=0; j<2; j++)
  for (unsigned long i=0; i<rsize; i++)
  {
    printf("%5i of %5i\x0D",j*rsize+i,rsize*2);
    unsigned long t = GetTickCount();
    char c;
    if (n_iter==0)
      c = getch();
    else
      c = 0x55;
    t -= GetTickCount();
    c ^= t;
    c -= my_random(256);
    c += c==0;
    if (j) r1[i]=c; else r2[i]=c;
  }
  n_iter++;

  r1[0] |= 0xC0;        // !!!
  r2[0] |= 0xC0;

  printf(" generating %i-bit keys...\n", keylen);

  key.create(r1,r2);

  printf("  e = %i\n", key.e.value->a[0]);

  if (END_E != 0)
  if (key.e.value->a[0] > END_E)
    goto restart;

  vlong d = modinv( key.e, (key.p-(vlong)1)*(key.q-(vlong)1) );

#define MAX(a,b)        a>b?a:b
  unsigned long maxlen = MAX(key.m.value->z, d.value->z);
  assert(maxlen == keylen/32);

  keyhash = 0;
  for (unsigned i=0; i<key.m.value->z; i++) keyhash ^= key.m.value->a[i];

  FILE*f;

  printf(" writing %s...\n", keyhpp);
  f=fopen(keyhpp,"wb");
  assert(f);
  fprintf(f,"// GENERATED FILE. DO NOT EDIT!\t\n\t\n");
  fprintf(f,"#define rsa_hash        0x0%08X  // key ID\t\n", keyhash);
  fprintf(f,"#define rsa_bit         %i\t\n\t\n", keylen);
  fdump_vlong_hpp(f,"n",key.m,maxlen);
  fdump_vlong_hpp(f,"d",d,maxlen);
  fdump_vlong_hpp(f,"e",key.e,maxlen);
#ifdef REDUNDANT_INFO
  fdump_vlong_hpp(f,"p",key.p,maxlen);
  fdump_vlong_hpp(f,"q",key.q,maxlen);
  vlong u = modinv( key.p, key.q );
  vlong dp = d % (key.p-(vlong)1);
  vlong dq = d % (key.q-(vlong)1);
  fdump_vlong_hpp(f,"u",u,maxlen);
  fdump_vlong_hpp(f,"dp",dp,maxlen);
  fdump_vlong_hpp(f,"dq",dq,maxlen);
#endif
  fclose(f);

  printf(" writing %s...\n", pubkey);
  f=fopen(pubkey,"wb");
  assert(f);
  fwrite(&keyhash, 1,4, f);
  fwrite(&keylen, 1,4, f);
  fdump_vlong_bin(f,key.m);
  fdump_vlong_bin(f,key.e);
  fclose(f);

  printf(" writing %s...\n", seckey);
  f=fopen(seckey,"wb");
  assert(f);
  fwrite(&keyhash, 1,4, f);
  fwrite(&keylen, 1,4, f);
  fdump_vlong_bin(f,key.m);
  fdump_vlong_bin(f,d);
#ifdef REDUNDANT_INFO
  fdump_vlong_bin(f,key.e);
  fdump_vlong_bin(f,key.p);
  fdump_vlong_bin(f,key.q);
  fdump_vlong_bin(f,u);
  fdump_vlong_bin(f,dp);
  fdump_vlong_bin(f,dq);
#endif
  fclose(f);

  printf(" writing %s...\n", pubinc);
  f=fopen(pubinc,"wb");
  assert(f);
  fprintf(f,"; GENERATED FILE. DO NOT EDIT!\t\n\t\n");
//fprintf(f,"rsa_hash                equ     0%08Xh  ; key ID\t\n", keyhash);
//fprintf(f,"rsa_bit                 equ     %i\t\n\t\n", keylen);
//fdump_vlong_inc(f,"n",key.m, maxlen);
//fdump_vlong_inc(f,"e",key.e, maxlen);
  fdump_vlong_asm(f,"n",key.m, maxlen);
  fclose(f);


  printf(" writing %s...\n", secinc);
  f=fopen(secinc,"wb");
  assert(f);
  fprintf(f,"; GENERATED FILE. DO NOT EDIT!\t\n\t\n");
//fprintf(f,"rsa_hash                equ     0%08Xh  ; key ID\t\n", keyhash);
//fprintf(f,"rsa_bit                 equ     %i\t\n\t\n", keylen);
//fdump_vlong_inc(f,"n",key.m, maxlen);
//fdump_vlong_inc(f,"d",d, maxlen);
  fdump_vlong_asm(f,"d",d, maxlen);
  fclose(f);

  printf(" testing key (encrypting/decrypting string)...\n");
  vlong x = from_str("motherfucker1234");
  vlong y = key.encrypt(x);
  vlong z = key.decrypt(y);
  printf(((x.value->z==z.value->z)&&(x.value->a[0]==z.value->a[0])) ?
         " success\n":"***ERROR***\n");

  printf(" dont forget to recompile key-dependent plugins\n");

}
