#include        "defs.h"


void    instrumentCallJmpRet(__in px86dis px86, __in unsigned long dest, __in unsigned long src){
        if (dest == 0xDEADC0DE){
                DbgPrint(("%s -- found killing code..", __FUNCTION__));
                DbgPrint(("%s -- dst = %.08X src = : %.08X", __FUNCTION__, dest, src));
                __asm jmp $
        }                      
}

void    instrumentException(__in PEXCEPTION_POINTERS pExceptionPointers){
        CONTEXT *pctx;
        EXCEPTION_RECORD *pExceptionRecord;
        PUCHAR  pbuff;
        unsigned long *pesp;
             
        pctx = pExceptionPointers->ContextRecord;
        pExceptionRecord = pExceptionPointers->ExceptionRecord;
        
        pesp = (unsigned long *)pctx->Esp;
        
        DbgPrint(("%s -- exception : %.08X at eip : %.08X", __FUNCTION__, pExceptionRecord->ExceptionCode, pctx->Eip));
        DbgPrint(("%s -- eflags    : %.08X esp content : %.08X", __FUNCTION__, pctx->EFlags, pesp));
        pbuff = (PUCHAR)pctx->Eip;
        DbgPrint(("%s -- Hexdump : ", __FUNCTION__));
        DbgPrint(("%s -- %.02X %.02X %.02X %.02X %.02X %.02X %.02X %.02X", __FUNCTION__,
                                                                          pbuff[0],     
                                                                          pbuff[1],
                                                                          pbuff[2],
                                                                          pbuff[3],
                                                                          pbuff[4],
                                                                          pbuff[5],
                                                                          pbuff[6],
                                                                          pbuff[7],
                                                                          pbuff[8]));
}


