                        .586p
                        .model  flat, stdcall
                        option  casemap:none

include                 .\i386\shitheap.inc

extrn  C                _imp__NtTerminateThread@8:dword
extrn  C                _imp__NtContinue@8:dword
extrn  C                decodeInstruction:proc

;#define TEB_THREAD_EXCEPTION    0xFF4 
TEB_THREAD_EXCEPTION    equ     0FF4h
TEB_EXCEPTION_SAVE_REG  equ     0FF8h
                       
                        .code
                        assume  fs:nothing

ntmemcmp                proc    C ptr0:dword, ptr1:dword, len:dword
                        push    esi
                        push    edi
                        xor     edx, edx
                        mov     eax, len
                        mov     ecx, 4
                        div     ecx
                        mov     esi, ptr0
                        mov     edi, ptr1
                        mov     ecx, len
                        shr     ecx, 2
                        cld
                        rep     cmpsd
                        jnz     __not_same
                        mov     ecx, edx
                        rep     cmpsb
                        jnz     __not_same
                        xor     eax, eax
                        jmp     __exit
                        
__not_same:             mov     eax, -1
__exit:                 pop     edi
                        pop     esi
                        ret
ntmemcmp                endp
                        
TerminateThreadAsm      proc    C  dlfree:dword, stack:dword, exit_code:dword, num_of_args:dword
                        lea     esi, num_of_args
                        add     esi, 4
                        mov     esp, stack
                        
                        mov     ecx, num_of_args
                        imul    ecx, ecx, 4
                        sub     esp, ecx        ;allocate some stack space for arguments...
                        
                        mov     edi, esp
                        cld
                        rep     movsb           ;copy all arguments to local stack...
                        mov     esi, esp
                        mov     edi, exit_code
                        mov     ecx, num_of_args
                        mov     ebx, dlfree
                        cld
__free:                 lodsd
                        push    ecx
                        push    eax
                        call    ebx
                        add     esp, 4
                        pop     ecx             
                        dec     ecx
                        jnz     __free
                        
                        push    edi
                        push    -2
                        call    _imp__NtTerminateThread@8
TerminateThreadAsm      endp 

                
ProbeForRead            proc    Address:dword, Len:dword, Alignment:dword
                        mov     dword ptr fs:[TEB_THREAD_EXCEPTION], offset __ExceptionProbeForRead
                        
                        mov     eax, Address
                        mov     ecx, Len
                        
                        dec     Alignment
                        jz      __loop1
                        dec     Alignment
                        jz      __loop2
                        dec     Alignment
                        dec     Alignment
                        jz      __loop4
                        
                        
__loop1:                mov     dl, byte ptr[eax]
                        inc     eax
                        loop    __loop1
                        xor     eax, eax
                        jmp     __exit                        
__loop2:                mov     dx, word ptr[eax]
                        add     eax, 2
                        loop    __loop2
                        xor     eax, eax
                        jmp     __exit

__loop4:                mov     edx, dword ptr[eax]
                        add     eax, 4
                        loop    __loop4
                        xor     eax, eax
                        jmp     __exit
                        
__ExceptionProbeForRead:
                        mov     ecx, [esp+4]
                        mov     eax, [ecx]
                        mov     ecx, [ecx+4]
                        mov     eax, [eax]      ;get exception code...
                        mov     [ecx.context.context_eax], eax
                        mov     [ecx.context.context_eip], offset __exit
                        push    0
                        push    ecx
                        call    _imp__NtContinue@8
__exit:                 mov     dword ptr fs:[TEB_THREAD_EXCEPTION], 0
                        ret
ProbeForRead            endp                          

ProbeForWrite           proc    Address:dword, Len:dword, Alignment:dword
                        mov     dword ptr fs:[TEB_THREAD_EXCEPTION], offset __ExceptionProbeForWrite
                        
                        mov     eax, Address
                        mov     ecx, Len
                        
                        dec     Alignment
                        jz      __loop1
                        dec     Alignment
                        jz      __loop2
                        dec     Alignment
                        dec     Alignment
                        jz      __loop4
                        
                        
__loop1:                mov     dl, byte ptr[eax]
                        mov     byte ptr[eax], dl
                        inc     eax
                        loop    __loop1
                        xor     eax, eax
                        jmp     __exit                        
__loop2:                mov     dx, word ptr[eax]
                        mov     word ptr[eax], dx
                        add     eax, 2
                        loop    __loop2
                        xor     eax, eax
                        jmp     __exit

__loop4:                mov     edx, dword ptr[eax]
                        mov     dword ptr[eax], edx
                        add     eax, 4
                        loop    __loop4
                        xor     eax, eax
                        jmp     __exit
                        
__ExceptionProbeForWrite:
                        mov     ecx, [esp+4]
                        mov     eax, [ecx]
                        mov     ecx, [ecx+4]
                        mov     eax, [eax]      ;get exception code...
                        mov     [ecx.context.context_eax], eax
                        mov     [ecx.context.context_eip], offset __exit
                        push    0
                        push    ecx
                        call    _imp__NtContinue@8
__exit:                 mov     dword ptr fs:[TEB_THREAD_EXCEPTION], 0
                        ret
ProbeForWrite           endp  

decodeInstructionWrapper proc   buffer:dword, px86:dword
                        push    esi
                        push    edi
                        push    ebx
                        push    ebp
                        mov     dword ptr fs:[TEB_THREAD_EXCEPTION], offset __ExcpetionDecodeInstruction
                        mov     dword ptr fs:[TEB_EXCEPTION_SAVE_REG], esp
                        
                        push    px86
                        push    buffer
                        call    decodeInstruction
                        add     esp, 8
                        xor     eax, eax
                        jmp     __exit
                        
__ExcpetionDecodeInstruction:
                        mov     ecx, [esp+4]
                        mov     eax, [ecx]
                        mov     ecx, [ecx+4]
                        mov     eax, [eax]
                        mov     [ecx.context.context_eax], eax
                        mov     eax, dword ptr fs:[TEB_EXCEPTION_SAVE_REG]
                        mov     [ecx.context.context_esp], eax
                        mov     [ecx.context.context_eip], offset __exit
                        push    0
                        push    ecx
                        call    _imp__NtContinue@8
__exit:                 mov     dword ptr fs:[TEB_THREAD_EXCEPTION], 0
                        mov     dword ptr fs:[TEB_EXCEPTION_SAVE_REG], 0
                        pop     ebp
                        pop     ebx
                        pop     edi
                        pop     esi
                        ret
decodeInstructionWrapper endp                        
                        end                        