#ifndef __DECODE__
#define __DECODE__

#define C_REG                   0x01
#define C_MEM                   0x02
#define C_IMM                   0x04

#define C_BASE_USED             0x10
#define C_INDEX_USED            0x20
#define C_SCALE_USED            0x40
#define C_DISPLACEMENT_USED     0x80
#define C_SEG_USED              0x100

#define MEM_NOMEM               0x0
#define MEM_READ                0x1    
#define MEM_WRITE               0x2    

typedef struct _x86dis{      
        unsigned long len;                  
        unsigned long iclass;
        unsigned long index;
        unsigned long base;
        unsigned long scale;
        unsigned long displacement;
        unsigned long seg;
        unsigned long num_of_operands;
        unsigned long mem_read_write;   //tells is memory operand is read or write
                                        //for visible members
        unsigned long mem_write;        //write if any of unstructions (hidden operand is write)
                                        //eg. pushfd/push movsb etc...
        union{
                struct{
                        unsigned long operand1_flags;
                        unsigned long operand2_flags;
                        unsigned long operand3_flags;
                };
                unsigned long operand_flags[3];
        };
        
        union{
                struct{
                        unsigned long operand1_size;
                        unsigned long operand2_size;
                        unsigned long operand3_size;
                };
                unsigned long operand_size[3];
        };
        
        union{
                struct{
                        unsigned long operand1;
                        unsigned long operand2;
                        unsigned long operand3;
                };
                unsigned long operand[3];
        };     
}x86dis, *px86dis;
        
unsigned long   decodeLen(__in void *buffer);
unsigned long   decodeIclass(__in void *buffer);
unsigned long   decodeIsEipRedirection(__in px86dis px86);
unsigned long   decodeIsJcc(__in px86dis px86);
unsigned long   decodeIsInt(__in px86dis px86);
unsigned long   decodeInstruction(__in void *buffer, px86dis px86);
NTSTATUS WINAPI decodeInstructionWrapper(__in void *buffer, px86dis px86);
#endif